package twiliodeliverymodels

type Status string

// Potential statuses taken from: https://www.twilio.com/docs/sms/tutorials/how-to-confirm-delivery-python#receive-status-events-in-your-web-application
const (
	Queued      Status = "queued"
	Failed      Status = "failed"
	Sent        Status = "sent"
	Delivered   Status = "delivered"
	Undelivered Status = "undelivered"
	Accepted    Status = "accepted"
	Sending     Status = "sending"
	Receiving   Status = "receiving"
	Received    Status = "received"
)

var ValidStatuses = map[Status]bool{
	Queued:      true,
	Failed:      true,
	Sent:        true,
	Delivered:   true,
	Undelivered: true,
	Accepted:    true,
	Sending:     true,
	Receiving:   true,
	Received:    true,
}

type UpsertSMSDeliveryStatusInput struct {
	Status      Status `json:"status" validate:"nonzero"`
	PhoneNumber string `json:"phone_number" validate:"nonzero"`
	AccountSID  string `json:"account_sid" validate:"nonzero"`
}

type Action string

const (
	Stop        Action = "STOP"
	End         Action = "END"
	Cancel      Action = "CANCEL"
	Unsubscribe Action = "UNSUBSCRIBE"
	Start       Action = "START"
	Help        Action = "HELP"
	Quit        Action = "QUIT"

	Unknown Action = "UNKNOWN"
)

var ValidActions = map[Action]bool{
	Stop:        true,
	End:         true,
	Cancel:      true,
	Unsubscribe: true,
	Start:       true,
	Help:        true,
	Quit:        true,
}

var StoppableActions = map[Action]bool{
	Stop:        true,
	End:         true,
	Cancel:      true,
	Unsubscribe: true,
	Start:       false,
	Help:        false,
	Quit:        true,
}

type UpsertSMSActionInput struct {
	Action      Action `json:"action" validate:"nonzero"`
	PhoneNumber string `json:"phone_number" validate:"nonzero"`
	AccountSID  string `json:"account_sid" validate:"nonzero"`
}

func (a Action) ToString() string {
	return string(a)
}
