package samus_gateway

// PrimeStatusResponse contains a TwitchUser's prime status and country
type PrimeStatusResponse struct {
	UserID      string `json:"twitchUserId"`
	TwitchPrime bool   `json:"twitchPrime"`
	CountryCode string `json:"countryCode"`
}

// GetBalanceResponse contains a users subscription credit balance
type GetBalanceResponse struct {
	SubscriptionCreditBalance int64 `json:"subscriptionCreditBalance"`
}

// CanSpendPrimeCreditResponse contains a boolean for whether the user can spend their credit on a given channel
type CanSpendPrimeCreditResponse struct {
	CanSpendPrimeCredit bool `json:"canSpendPrimeCredit"`
}

// SpendSubscriptionCreditResponse ...
type SpendSubscriptionCreditResponse struct {
	UserID                    string `json:"twitchUserId"`
	BroadcasterID             string `json:"broadcasterId"`
	SubscriptionCreditBalance int64  `json:"subscriptionCreditBalance"`
}

// SpendSubscriptionCreditRequest body
type SpendSubscriptionCreditRequestBody struct {
	ProductID string   `json:"productId"`
	Channels  []string `json:"channels"`
}

// UnspendSubscriptionCreditResponse ...
type UnspendSubscriptionCreditResponse struct {
	TransactionID string `json:"transactionId"`
}

// CurrentPrimeOffersResponse contains current list of Prime Offers that are live
type CurrentPrimeOffersResponse struct {
	PrimeOffers []PrimeOffer `json:"offerList"`
}

// PrimeOffer contains data for a single Prime Offer
type PrimeOffer struct {
	OfferID                 string       `json:"offerId"`
	ApplicableGame          string       `json:"applicableGame"`
	ContentClaimInstruction string       `json:"contentClaimInstruction"`
	ContentDeliveryMethod   string       `json:"contentDeliveryMethod"`
	StartTime               string       `json:"startTime"`
	EndTime                 string       `json:"endTime"`
	ExternalOfferUri        string       `json:"externalOfferUri"`
	OfferTitle              string       `json:"offerTitle"`
	OfferDescription        string       `json:"offerDescription"`
	Priority                int          `json:"priority"`
	PublisherName           string       `json:"publisherName"`
	ContentCategories       []string     `json:"contentCategories"`
	Assets                  []OfferAsset `json:"assets"`
	VendorSKUs              []string     `json:"vendorSkus"`
	Tags                    OfferTag     `json:"tags"`
}

type OfferTag struct {
	Audience string `json:"audience"`
	Group    string `json:"group"`
}

type OfferAsset struct {
	AssetType  string `json:"assetType"`
	Location   string `json:"location"`
	Location2x string `json:"location2x"`
	MediaType  string `json:"mediaType"`
}

// PrimeOfferEntitlementResponse contains data about the users claimed offer entitlement
type PrimeOfferEntitlementResponse struct {
	HasEntitlement     bool               `json:"hasEntitlement"`
	UserID             string             `json:"twitchUserId"`
	OfferClaimMetadata OfferClaimMetadata `json:"offerClaimCode"`
	ClaimMethod        string             `json:"claimMethod"`
	OfferID            string             `json:"offerId"`
	OfferTitle         string             `json:"offerTitle"`
	OfferClaimData     string             `json:"offerClaimData"`
	ClaimInstruction   string             `json:"contentClaimInstruction"`
}

// OfferClaimMetadata has values returned for claim code metadata
type OfferClaimMetadata struct {
	OfferID   string `json:"offerId"`
	CodeValue string `json:"codeValue"`
	CodeLabel string `json:"codeLabel"`
}

type GetPrimeOfferBySKURequest struct {
	UserID      string
	CountryCode string
	Locale      string
	SKU         string
}

type GetPrimeOfferBySKUResponse struct {
	Offer *PrimeOffer `json:"primeOffer"`
}

type GetDynamicStringResponse struct {
	DynamicStringMap map[string]DynamicString `json:"dynamicStringMap"`
}

type DynamicString struct {
	ID             string `json:"id"`
	Text           string `json:"text"`
	ExternalUrl    string `json:"externalUrl"`
	IsExternalLink bool   `json:"isExternalLink"`
}

type GameAccount struct {
	AccountID   string `json:"accountId"`
	DisplayName string `json:"displayName"`
}

type GameAccountLink struct {
	UserID      string      `json:"userId"`
	GameAccount GameAccount `json:"gameAccount"`
}

type CreateAccountLinkRequestBody struct {
	GameAccount GameAccount `json:"gameAccount"`
}

type CreateAccountLinkResponse struct {
	AccountLink GameAccountLink `json:"accountLink"`
}

type GetAccountLinkResponse struct {
	AccountLink GameAccountLink `json:"accountLink"`
}

type DeleteAccountLinkResponse struct {
	Deleted *GameAccountLink `json:"deleted"`
}

// PrimeSettings for a Twitch Prime user
type PrimeSettings struct {
	IsSubscriptionMessage bool `json:"isSubscriptionMessage"`
}

// GetPrimeSettingsResponse is the collection of settings for a Twitch Prime user
type GetPrimeSettingsResponse struct {
	UserID                string `json:"twitchUserId"`
	IsSubscriptionMessage bool   `json:"isSubscriptionMessage"`
}

// SetPrimeSettingsRequestBody is the collection of settings to be sent for update
type SetPrimeSettingsRequestBody struct {
	IsSubscriptionMessage bool `json:"isSubscriptionMessage"`
}

// SetPrimeSettingsResponse is the collection of settings for a Twitch user after update
type SetPrimeSettingsResponse struct {
	UserID                string `json:"twitchUserId"`
	IsSubscriptionMessage bool   `json:"isSubscriptionMessage"`
}
