module.exports.GameLogic = require('./lib/controllers/GameLogic.js');
module.exports.GameMap = require('./lib/models/GameMap.js');
module.exports.GameState = require('./lib/models/GameState.js');
module.exports.Player = require('./lib/models/Player.js');
module.exports.RoundResultsTimer = require('./lib/models/RoundResultsTimer.js');
module.exports.DynamoTypes = require('./lib/types/DynamoTypes.js');
module.exports.Constants = require('./lib/constants.js');

/** Takes the old state and the game inputs and returns the new state. */
module.exports.calculateNewState = function(oldDynamoGameState, roundInputs) {
    const workingStateObject = new module.exports.GameState.GameState(oldDynamoGameState, false);

    roundInputs.forEach((item) => {
        workingStateObject.applyInputToPlayer(item.opaqueUserID, item.input);
    });

    // Run instant physics on the working state so we immediately get the round results.
    module.exports.GameLogic.GameLogic.startPhysicsSimulation(workingStateObject, true);
    workingStateObject.recordExpectedEndState();
    workingStateObject.incrementRoundNumber();
    
    const newDynamoGameState = workingStateObject.createDynamoGameState();

    newDynamoGameState.nextInputCutoffTimestamp = 
        Date.now() + 
        module.exports.Constants.FULL_ROUND_DURATION_SEC*1000 - 
        module.exports.Constants.HALF_HIGHEST_SUPPORTED_PING;
    
    return newDynamoGameState;
}