"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RoundResultsTimer_js_1 = require("./models/RoundResultsTimer.js");
exports.TICK_RATE_SEC = 60.0;
exports.TICK_LENGTH_SEC = 1.0 / exports.TICK_RATE_SEC;
// Max number of rounds in a game.
exports.HALF_HIGHEST_SUPPORTED_PING = 1500.0;
// Duration in seconds for a regular input phase during which players can submit inputs.
exports.INPUT_PHASE_DURATION_SEC = 6.0;
// Duration in seconds for the first round's input phase.
exports.FIRST_ROUND_INPUT_PHASE_DURATION_SEC = 8.0;
// Duration in seconds for the drumroll phase between the last possible input submission and 
// displaying the new state on the client. The server's calculations must complete during this time.
exports.DRUMROLL_PHASE_DURATION_SEC = 2.5;
// Duration in seconds for the results phase during which players will see the results of all inputs
// play out at regular speed.
exports.RESULTS_PHASE_DURATION_SEC = RoundResultsTimer_js_1.calculateFullResultsDurationSec();
// Duration in seconds for a full round (using the regular input phase duration).
exports.FULL_ROUND_DURATION_SEC = exports.INPUT_PHASE_DURATION_SEC + exports.DRUMROLL_PHASE_DURATION_SEC + exports.RESULTS_PHASE_DURATION_SEC;
// Max number of rounds in a game.
exports.MAX_NUMBER_OF_ROUNDS_PER_GAME = 8;
