import { GameState } from "../models/GameState";
export declare class GameLogic {
    private static readonly SHRINK_PER_TICK;
    private static readonly FRICTION_COEFF;
    private static readonly COLLISION_SEPARATION_COEFF;
    /** Starts the physics simulation.
     * Setting instantResults to true will execute all the updates for the round synchronously.
     * Otherwise, this function sets up the simulation at a regular speed. */
    static startPhysicsSimulation(gameState: GameState, instantResults: boolean): void;
    /** Run the update functions until we are caught up to the provided timestamp.
     * This allows for clients connecting halfway-through a game to see an accurate
     * version of the game. */
    static updateUntilGivenTime(gameState: GameState, time: number): void;
    /** Run the movement update for one tick. */
    private static updateMovementOneTick;
    /** Run the map shrinking update for one tick. */
    private static updateMapShrinkOneTick;
    /** Check for any player deaths. */
    static handleDeaths(gameState: GameState): void;
    /** Check and handle any collisions between all players. */
    private static handleCollisions;
    /** Returns whether the specified players are colliding. */
    private static playersAreColliding;
    /** Check and handle a potential collision between the two specified players. */
    private static handlePotentialCollision;
}
