import Victor = require('victor');
import { DynamoMapState } from "../types/DynamoTypes";
export declare class GameMap {
    static readonly DEFAULT_SAFE_ZONE_RADIUS: number;
    static readonly SHRINK_PER_ROUND: number;
    private roundStartSafeZoneRadius;
    private currentSafeZoneRadius;
    private roundEndSafeZoneRadius;
    private dynamoMapState;
    /** Creates a GameMap instance based on the dynamoDB object.
     * The useRoundStartValues flag indicates whether the returned GameMap instance should use
     * the round start values from the dynamoDB object for safe zone radius
     * (ex: to replay the changes on the client side). */
    constructor(dynamoMapState: DynamoMapState, useRoundStartValues?: boolean);
    /** Create a DynamoMapState from this GameMap object to store its data in DynamoDB. */
    createDynamoMapState(): DynamoMapState;
    /** Set the map's current safe zone radius its expected end value. Use this to reconcile the client-side
     * map radius with the expected result calculated on the server-side. */
    reconcileWithExpectedEndState(): void;
    /** Sets the expected end state to the current values. */
    recordExpectedEndState(): void;
    shrinkMap(shrinkAmount: number): void;
    isInSafeZone(v: Victor): boolean;
    getSafeZoneRadius(): number;
}
