import { Player } from "./Player";
import { GameMap } from "./GameMap";
import { DynamoGameState } from "../types/DynamoTypes";
import { RoundResultsTimer } from "./RoundResultsTimer";
export declare enum GamePhase {
    STANDBY = 0,
    INPUT_PHASE = 1,
    DRUMROLL_PHASE = 2,
    RESULTS_PHASE = 3,
    GAME_FINISHED = 4
}
export declare class GameState {
    players: Player[];
    gameMap: GameMap;
    private gamePhase;
    roundResultsTimer: RoundResultsTimer;
    lastProcessedResultsTick: number;
    lastPlayerToDie: Player | null;
    private dynamoGameState;
    /** Creates a GameState instance based on the dynamoDB object.
     * The useRoundStartValues flag indicates whether the returned GameState instance should use
     * the round start values from the dynamoDB object for safe zone radius and player states
     * (ex: to replay the changes on the client side). */
    constructor(dynamoGameState: DynamoGameState, useRoundStartValues: boolean, roundEndCallback?: () => void);
    readonly gameID: string | null;
    /** Get the DynamoPlayerStates from all the players in this game. */
    private getDynamoPlayerStates;
    getGamePhase(): GamePhase;
    setGamePhase(newPhase: GamePhase): void;
    /** Increments the round number for this game state. */
    incrementRoundNumber(): void;
    /** Applies the provided inputs to their players. Returns true for success, false for failure. */
    applyInputToPlayer(opaqueUserID: string, input: {
        x: number;
        y: number;
    }): boolean;
    /** Set the player's current position to its expected end value. Use this to reconcile the client-side
     * player position with the expected result calculated on the server-side. */
    reconcileWithExpectedEndState(): void;
    /** Sets the expected end state to the current values. */
    recordExpectedEndState(): void;
    /** Create a DynamoGameState from this GameState object to store its data in DynamoDB. */
    createDynamoGameState(): DynamoGameState;
    /** Returns the player metadata for the winning player, or null if there is no winner. */
    private getGameWinnerMetadata;
    /** Places all the players at their spawn positions. */
    placePlayersAtSpawnPositions(): void;
    getRoundNumber(): number;
    getCurrentRoundResultsStartTimestamp(): number;
    getNextRoundInputStartTimestamp(): number;
    getNextRoundInputCutoffTimestamp(): number;
    getNextRoundEarliestStatePollTimestamp(): number;
}
