import Victor = require('victor');
import { DynamoPlayerState, PlayerMetadata } from "../types/DynamoTypes";
export declare class Player {
    static readonly PLAYER_RADIUS = 12;
    static readonly PLAYER_MASS = 1;
    private static readonly SPEED_SCALE;
    static readonly MAX_INPUT_MAGNITUDE = 275;
    private dynamoPlayerState;
    dead: boolean;
    roundStartPosition: Victor;
    roundEndPosition: Victor;
    currentPosition: Victor;
    velocity: Victor;
    private roundInput;
    /** Creates a Player instance based on the dynamoDB object.
     * The useRoundStartValues flag indicates whether the returned GameState instance should use
     * the round start values from the dynamoDB object for the player position and input
     * (ex: to replay the changes on the client side). */
    constructor(dynamoPlayerState: DynamoPlayerState, useRoundStartValues?: boolean);
    /** Create a DynamoPlayerState from this Player object to store its data in DynamoDB. */
    createDynamoPlayerState(): DynamoPlayerState;
    getPlayerMetadata(): PlayerMetadata;
    /** Set the player's current position to its expected end value. Use this to reconcile the client-side
     * player position with the expected result calculated on the server-side. */
    reconcileWithExpectedEndState(): void;
    /** Sets the expected end state to the current values. */
    recordExpectedEndState(): void;
    /** Calculates the player's velocity from their input. */
    private calculateVelocityFromInput;
    setRoundInput(x: number, y: number): void;
    getRoundInput(): Victor;
}
