export declare enum ResultsPhase {
    SHOW_INPUTS = "SHOW_INPUTS",
    LAUNCH_PLAYERS = "LAUNCH_PLAYERS",
    MAP_SHRINK = "MAP_SHRINK"
}
/** Returns the number of seconds in the specified phase. */
export declare function getPhaseDurationSec(phase: ResultsPhase): 1.7 | 2 | 0.5 | 0;
/** Returns the number of ticks in the specified phase. */
export declare function getPhaseDurationTick(phase: ResultsPhase): number;
/** Calculates and returns the total duration in seconds of all results phases. */
export declare function calculateFullResultsDurationSec(): number;
/** Class that keeps track of the results phase without using timeouts or intervals. */
export declare class RoundResultsTimer {
    private startTime;
    private roundEndCallback;
    /** Create a new timer instance. */
    constructor(roundEndCallback?: () => void);
    /** Returns the game tick corresponding to the given timestamp. */
    getTickForTime(currentTime?: number): number;
    /** Returns the phase which the RoundResultsTimer is currently on. */
    getPhaseForTime(currentTime?: number): ResultsPhase | null;
    /** Returns the phase which the given tick would be on. */
    getPhaseForTick(tick: number): ResultsPhase | null;
    timerIsRunning(): boolean;
    /** Starts the timer, optionally providing a start timestamp to start the timer at that moment (past, present, or future). */
    startTimer(startTime?: number): void;
    /** Stops the timer. */
    stopTimer(): void;
}
