export interface DynamoGameState {
    gameID: string | null;
    gameWinnerMetadata: PlayerMetadata | null;
    roundNumber: number;
    nextInputCutoffTimestamp: number;
    mapState: DynamoMapState;
    playerStates: DynamoPlayerState[];
}
export interface DynamoMapState {
    roundStartSafeZoneRadius: number;
    roundEndSafeZoneRadius: number;
}
export interface DynamoPlayerState {
    playerMetadata: PlayerMetadata;
    roundStartPosition: {
        x: number;
        y: number;
    };
    roundEndPosition: {
        x: number;
        y: number;
    };
    roundInput: {
        x: number;
        y: number;
    };
}
export interface PlayerMetadata {
    opaqueUserID: string;
    username: string;
}
/** Creates an initial DynamoGameState for a new game. */
export declare function createInitialDynamoGameState(gameID: string, participatingPlayerMetadata: PlayerMetadata[]): DynamoGameState;
