"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameMap_1 = require("../models/GameMap");
var GameState_1 = require("../models/GameState");
var constants_1 = require("../constants");
/** Creates an initial DynamoMapState object for the map in a new game. */
function createInitialDynamoMapState() {
    return ({
        roundStartSafeZoneRadius: GameMap_1.GameMap.DEFAULT_SAFE_ZONE_RADIUS,
        roundEndSafeZoneRadius: GameMap_1.GameMap.DEFAULT_SAFE_ZONE_RADIUS,
    });
}
/** Creates an initial DynamoPlayerState object for a player in a new game. */
function createInitialDynamoPlayerState(playerMetadata) {
    return ({
        playerMetadata: playerMetadata,
        roundStartPosition: {
            x: 0,
            y: 0,
        },
        roundEndPosition: {
            x: 0,
            y: 0,
        },
        roundInput: {
            x: 0,
            y: 0,
        },
    });
}
/** Creates an initial DynamoGameState for a new game. */
function createInitialDynamoGameState(gameID, participatingPlayerMetadata) {
    var firstInputCutoffTimestamp = Date.now() + constants_1.FIRST_ROUND_INPUT_PHASE_DURATION_SEC * 1000 - constants_1.HALF_HIGHEST_SUPPORTED_PING;
    var initialPlayerStates = [];
    participatingPlayerMetadata.forEach(function (playerMetadata) {
        initialPlayerStates.push(createInitialDynamoPlayerState(playerMetadata));
    });
    var initialMapState = createInitialDynamoMapState();
    // Game state without the players placed at their spawn positions.
    var noPlacementDynamoGameState = {
        gameID: gameID,
        gameWinnerMetadata: null,
        roundNumber: 0,
        nextInputCutoffTimestamp: firstInputCutoffTimestamp,
        mapState: initialMapState,
        playerStates: initialPlayerStates,
    };
    var gameState = new GameState_1.GameState(noPlacementDynamoGameState, true);
    gameState.placePlayersAtSpawnPositions();
    return gameState.createDynamoGameState();
}
exports.createInitialDynamoGameState = createInitialDynamoGameState;
