import { calculateFullResultsDurationSec } from "./models/RoundResultsTimer.js";

export const TICK_RATE_SEC: number = 60.0;
export const TICK_LENGTH_SEC: number = 1.0/TICK_RATE_SEC;

// Max number of rounds in a game.
export const HALF_HIGHEST_SUPPORTED_PING: number = 1500.0;

// Duration in seconds for a regular input phase during which players can submit inputs.
export const INPUT_PHASE_DURATION_SEC: number = 6.0;
// Duration in seconds for the first round's input phase.
export const FIRST_ROUND_INPUT_PHASE_DURATION_SEC: number = 8.0;
// Duration in seconds for the drumroll phase between the last possible input submission and 
// displaying the new state on the client. The server's calculations must complete during this time.
export const DRUMROLL_PHASE_DURATION_SEC: number = 2.5;
// Duration in seconds for the results phase during which players will see the results of all inputs
// play out at regular speed.
export const RESULTS_PHASE_DURATION_SEC: number = calculateFullResultsDurationSec();
// Duration in seconds for a full round (using the regular input phase duration).
export const FULL_ROUND_DURATION_SEC: number = INPUT_PHASE_DURATION_SEC + DRUMROLL_PHASE_DURATION_SEC + RESULTS_PHASE_DURATION_SEC;

// Max number of rounds in a game.
export const MAX_NUMBER_OF_ROUNDS_PER_GAME: number = 8;