resource "terraform_remote_state" "twitch_web_dev" {
  backend = "s3"
  config {
    bucket = "twitch-web-dev"
    key = "tfstate/web/terraform/accounts/twitch-web-dev"
  }
}

resource "terraform_remote_state" "web_notification_sns" {
  backend = "s3"
  config {
    bucket = "twitch-web-dev"
    key = "tfstate/web/terraform/services/sns/staging"
  }
}

module "staging" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/web-stage.git?ref=v1.9"
  env = "${var.env}"
  app_env = "staging"
  count = "${var.count}"
  owner = "${var.owner}"
  vpc_id = "${terraform_remote_state.twitch_web_dev.output.vpc_id}"
  subnet_ids = "${terraform_remote_state.twitch_web_dev.output.service_subnets}"
  security_group_id = "${terraform_remote_state.twitch_web_dev.output.twitch_subnets_sg}"
  sns_topic_arns = "${terraform_remote_state.web_notification_sns.output.arn_notification_all}"

  public_enabled = 1
  public_access_cidrs = "${var.public_access_cidrs}"
  public_subnet_ids = "subnet-b3af88d6,subnet-1e763369,subnet-ced54a97"
}
