package fruitinmemory

import "code.justin.tv/security-cop/fruit"

// New returns a new fruits client
func New() *Fruits {
	return &Fruits{
		db: make(map[string]*fruit.Fruit),
	}
}

// Fruits is the client to interact with fruits
type Fruits struct {
	db map[string]*fruit.Fruit
}

// Get fruit
func (f *Fruits) Get(id string) (*fruit.Fruit, error) {
	item, ok := f.db[id]
	if !ok {
		return nil, fruit.NotFoundError{ID: id}
	}
	return item, nil
}

// UpdatePrice of a fruit
func (f *Fruits) UpdatePrice(id string, priceInDollars int) error {
	f.db[id] = &fruit.Fruit{ID: id, Price: priceInDollars}
	return nil
}
