package main

import (
	"bytes"
	"io/ioutil"
	"net/http"
	"net/http/httptest"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestFruitHandler(t *testing.T) {
	t.Run("update then get grapefruit price", func(t *testing.T) {
		testServer := httptest.NewServer(NewFruitHandler())
		defer testServer.Close()
		client := &http.Client{}

		// update the price to 16
		requestBody := bytes.NewBuffer(nil)
		requestBody.Write([]byte("grapefruit 16"))
		req, err := http.NewRequest(http.MethodPost, testServer.URL, requestBody)
		require.NoError(t, err)
		req.URL.Path = "/update_price"

		res, err := client.Do(req)
		require.NoError(t, err)
		defer res.Body.Close()
		require.Equal(t, http.StatusOK, res.StatusCode)

		resBody, err := ioutil.ReadAll(res.Body)
		require.NoError(t, err)
		assert.Equal(t, "grapefruit 16", string(resBody))

		// get the price and expect to be 16
		requestBody = bytes.NewBuffer(nil)
		requestBody.Write([]byte("grapefruit"))
		req, err = http.NewRequest(http.MethodPost, testServer.URL, requestBody)
		require.NoError(t, err)
		req.URL.Path = "/get_price"

		res, err = client.Do(req)
		require.NoError(t, err)
		defer res.Body.Close()
		require.Equal(t, http.StatusOK, res.StatusCode)

		resBody, err = ioutil.ReadAll(res.Body)
		require.NoError(t, err)
		assert.Equal(t, "grapefruit 16", string(resBody))
	})
}
