// Code generated by ./idlistgen. DO NOT EDIT.
package main

import (
	"sort"
	"strings"

	"github.com/graph-gophers/graphql-go"
)

type itemsAPI interface {
  After(id *graphql.ID) items
  First(n int32) items
  Get(id graphql.ID) (*item, bool)
  Len() int
  Less(i, j int) bool
  Swap(i, j int)
}

type items []*item

func (ps items) After(id *graphql.ID) items {
	simulateLatency()
	if id != nil {
    nLocation := ps.location(*id)
    return ps[nLocation + 1:]
	}
	return ps
}

func (ps items) First(n int32) items {
	simulateLatency()
	if len(ps) > int(n) {
		return ps[:n]
	}
	return ps
}

func (ps items) Get(id graphql.ID) (*item, bool) {
	simulateLatency()
	if location := ps.location(id); location < len(ps) {
		return ps[location], true
	}
	return nil, false
}

func (ps items) location(id graphql.ID) int {
	return sort.Search(len(ps), ps.forID(id))
}

func (ps items) forID(id graphql.ID) func(int) bool {
	return func(n int) bool {
		return strings.Compare(string(ps[n].ID()), string(id)) >= 0
	}
}

func (ps items) Len() int {
	return len(ps)
}

func (ps items) Less(i, j int) bool {
	return strings.Compare(string(ps[i].ID()), string(ps[j].ID())) < 0
}

func (ps items) Swap(i, j int) {
	ps[i], ps[j] = ps[j], ps[i]
}
