package main

import (
	"flag"
	"log"
	"os"
	"text/template"
)

const idList = `// Code generated by ./idlistgen. DO NOT EDIT.
package {{ .Package }}

import (
	"sort"
	"strings"

	"github.com/graph-gophers/graphql-go"
)

type {{ .Plural }}API interface {
  After(id *graphql.ID) {{ .Plural }}
  First(n int32) {{ .Plural }}
  Get(id graphql.ID) (*{{ .Singular }}, bool)
  Len() int
  Less(i, j int) bool
  Swap(i, j int)
}

type {{ .Plural }} []*{{ .Singular }}

func (ps {{ .Plural }}) After(id *graphql.ID) {{ .Plural }} {
	simulateLatency()
	if id != nil {
    nLocation := ps.location(*id)
    return ps[nLocation + 1:]
	}
	return ps
}

func (ps {{ .Plural }}) First(n int32) {{ .Plural }} {
	simulateLatency()
	if len(ps) > int(n) {
		return ps[:n]
	}
	return ps
}

func (ps {{ .Plural }}) Get(id graphql.ID) (*{{ .Singular }}, bool) {
	simulateLatency()
	if location := ps.location(id); location < len(ps) {
		return ps[location], true
	}
	return nil, false
}

func (ps {{ .Plural }}) location(id graphql.ID) int {
	return sort.Search(len(ps), ps.forID(id))
}

func (ps {{ .Plural }}) forID(id graphql.ID) func(int) bool {
	return func(n int) bool {
		return strings.Compare(string(ps[n].ID()), string(id)) >= 0
	}
}

func (ps {{ .Plural }}) Len() int {
	return len(ps)
}

func (ps {{ .Plural }}) Less(i, j int) bool {
	return strings.Compare(string(ps[i].ID()), string(ps[j].ID())) < 0
}

func (ps {{ .Plural }}) Swap(i, j int) {
	ps[i], ps[j] = ps[j], ps[i]
}
`

func main() {
	var templateInput struct {
		Package  string
		Plural   string
		Singular string
	}

	flag.StringVar(&templateInput.Package, "package", "resolver", "package name")
	flag.StringVar(&templateInput.Plural, "plural", "", "item plural")
	flag.StringVar(&templateInput.Singular, "singular", "", "item singular")
	output := flag.String("o", "", "output")
	flag.Parse()

	f, err := os.Create(*output)
	if err != nil {
		panic(err)
	}
	defer f.Close()

	t := template.Must(template.New("idList").Parse(idList))
	if err := t.Execute(f, templateInput); err != nil {
		panic(err)
	}

	log.Printf("generated %s", *output)
}

func simulateLatency() {
}
