// Code generated by ./idlistgen. DO NOT EDIT.
package resolver

import (
	"sort"
	"strings"

	"github.com/graph-gophers/graphql-go"
)

type postsAPI interface {
  After(id *graphql.ID) posts
  First(n int32) posts
  Get(id graphql.ID) (*post, bool)
  Len() int
  Less(i, j int) bool
  Swap(i, j int)
}

type posts []*post

func (ps posts) After(id *graphql.ID) posts {
	simulateLatency()
	if id != nil {
    nLocation := ps.location(*id)
    return ps[nLocation + 1:]
	}
	return ps
}

func (ps posts) First(n int32) posts {
	simulateLatency()
	if len(ps) > int(n) {
		return ps[:n]
	}
	return ps
}

func (ps posts) Get(id graphql.ID) (*post, bool) {
	simulateLatency()
	if location := ps.location(id); location < len(ps) {
		return ps[location], true
	}
	return nil, false
}

func (ps posts) location(id graphql.ID) int {
	return sort.Search(len(ps), ps.forID(id))
}

func (ps posts) forID(id graphql.ID) func(int) bool {
	return func(n int) bool {
		return strings.Compare(string(ps[n].ID()), string(id)) >= 0
	}
}

func (ps posts) Len() int {
	return len(ps)
}

func (ps posts) Less(i, j int) bool {
	return strings.Compare(string(ps[i].ID()), string(ps[j].ID())) < 0
}

func (ps posts) Swap(i, j int) {
	ps[i], ps[j] = ps[j], ps[i]
}
