// Code generated by ./idlistgen. DO NOT EDIT.
package resolver

import (
	"sort"
	"strings"

	"github.com/graph-gophers/graphql-go"
)

type timelineEntriesAPI interface {
  After(id *graphql.ID) timelineEntries
  First(n int32) timelineEntries
  Get(id graphql.ID) (*timelineEntry, bool)
  Len() int
  Less(i, j int) bool
  Swap(i, j int)
}

type timelineEntries []*timelineEntry

func (ps timelineEntries) After(id *graphql.ID) timelineEntries {
	simulateLatency()
	if id != nil {
    nLocation := ps.location(*id)
    return ps[nLocation + 1:]
	}
	return ps
}

func (ps timelineEntries) First(n int32) timelineEntries {
	simulateLatency()
	if len(ps) > int(n) {
		return ps[:n]
	}
	return ps
}

func (ps timelineEntries) Get(id graphql.ID) (*timelineEntry, bool) {
	simulateLatency()
	if location := ps.location(id); location < len(ps) {
		return ps[location], true
	}
	return nil, false
}

func (ps timelineEntries) location(id graphql.ID) int {
	return sort.Search(len(ps), ps.forID(id))
}

func (ps timelineEntries) forID(id graphql.ID) func(int) bool {
	return func(n int) bool {
		return strings.Compare(string(ps[n].ID()), string(id)) >= 0
	}
}

func (ps timelineEntries) Len() int {
	return len(ps)
}

func (ps timelineEntries) Less(i, j int) bool {
	return strings.Compare(string(ps[i].ID()), string(ps[j].ID())) < 0
}

func (ps timelineEntries) Swap(i, j int) {
	ps[i], ps[j] = ps[j], ps[i]
}
