package resolver

import (
	"github.com/graph-gophers/graphql-go"
)

// TimelineEntryType represents a type of a timeline entry
type TimelineEntryType int

// timeline entry types
const (
	PostTimelineEntryType TimelineEntryType = iota
	SponsoredPostTimelineEntryType
)

// TimelineEntryFields ...
type TimelineEntryFields struct {
	ID        graphql.ID
	EntryType TimelineEntryType
}

type timelineEntry struct {
	fields TimelineEntryFields

	posts          postsAPI
	sponsoredPosts sponsoredPostsAPI
}

func (te *timelineEntry) ID() graphql.ID {
	return te.fields.ID
}

func (te *timelineEntry) ToPost() (*post, bool) {
	if te.fields.EntryType == PostTimelineEntryType {
		return te.posts.Get(te.fields.ID)
	}
	return nil, false
}

func (te *timelineEntry) ToSponsoredPost() (*sponsoredPost, bool) {
	if te.fields.EntryType == SponsoredPostTimelineEntryType {
		return te.sponsoredPosts.Get(te.fields.ID)
	}
	return nil, false
}
