// Code generated by ./idlistgen. DO NOT EDIT.
package resolver

import (
	"sort"
	"strings"

	"github.com/graph-gophers/graphql-go"
)

type usersAPI interface {
  After(id *graphql.ID) users
  First(n int32) users
  Get(id graphql.ID) (*user, bool)
  Len() int
  Less(i, j int) bool
  Swap(i, j int)
}

type users []*user

func (ps users) After(id *graphql.ID) users {
	simulateLatency()
	if id != nil {
    nLocation := ps.location(*id)
    return ps[nLocation + 1:]
	}
	return ps
}

func (ps users) First(n int32) users {
	simulateLatency()
	if len(ps) > int(n) {
		return ps[:n]
	}
	return ps
}

func (ps users) Get(id graphql.ID) (*user, bool) {
	simulateLatency()
	if location := ps.location(id); location < len(ps) {
		return ps[location], true
	}
	return nil, false
}

func (ps users) location(id graphql.ID) int {
	return sort.Search(len(ps), ps.forID(id))
}

func (ps users) forID(id graphql.ID) func(int) bool {
	return func(n int) bool {
		return strings.Compare(string(ps[n].ID()), string(id)) >= 0
	}
}

func (ps users) Len() int {
	return len(ps)
}

func (ps users) Less(i, j int) bool {
	return strings.Compare(string(ps[i].ID()), string(ps[j].ID())) < 0
}

func (ps users) Swap(i, j int) {
	ps[i], ps[j] = ps[j], ps[i]
}
