package resolver

import (
	"sort"
	"testing"

	"github.com/graph-gophers/graphql-go"
	"github.com/stretchr/testify/assert"
)

func TestUsers(t *testing.T) {
	t.Run("Get", func(t *testing.T) {
		us := users{
			&user{
				fields: UserFields{
					ID: "id-1",
				},
			},
			&user{
				fields: UserFields{
					ID: "id-0",
				},
			},
		}
		sort.Sort(us)

		assert.Equal(t, users{
			&user{
				fields: UserFields{
					ID: "id-0",
				},
			},
			&user{
				fields: UserFields{
					ID: "id-1",
				},
			},
		}, us)

		u, ok := us.Get(graphql.ID("id-0"))
		assert.True(t, ok)
		assert.Equal(t, &user{
			fields: UserFields{
				ID: "id-0",
			},
		}, u)
	})
}
