package main

import (
	"flag"
	"io/ioutil"
	"os"
	"text/template"
)

var tmpl = template.Must(
	template.New("dashboard").Parse(`// Code generated by ./schema_gen. DO NOT EDIT.

package main

const schema = ` + "`" + `{{.Schema}}` + "`" + `
`))

func main() {
	in := flag.String("schema-path", "", "input to use")
	out := flag.String("out", "", "input to use")
	flag.Parse()

	f, err := os.Create(*out)
	if err != nil {
		panic(err)
	}

	if err := tmpl.Execute(f, struct {
		Schema string
	}{
		Schema: rawSchema(*in),
	}); err != nil {
		panic(err)
	}
}

func rawSchema(in string) string {
	f, err := os.Open(in)
	if err != nil {
		panic(err)
	}
	defer f.Close()

	bs, err := ioutil.ReadAll(f)
	if err != nil {
		panic(err)
	}

	return string(bs)
}
