package cache

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestStringCache(t *testing.T) {
	t.Run("add new key", func(t *testing.T) {
		sc := NewStringCache()
		sc.Add("a", "b")
		assert.Equal(t, "b", sc.Fetch("a"))
	})

	t.Run("add existing key", func(t *testing.T) {
		sc := NewStringCache()
		sc.Add("a", "b")
		sc.Add("a", "c")
		assert.Equal(t, "c", sc.Fetch("a"))
	})

	t.Run("fetch from empty", func(t *testing.T) {
		sc := NewStringCache()
		assert.Equal(t, "", sc.Fetch("c"))
	})

	t.Run("fetch missing key", func(t *testing.T) {
		sc := NewStringCache()
		sc.Add("a", "b")
		assert.Equal(t, "", sc.Fetch("c"))
	})
}
