const HtmlWebpackPlugin = require("html-webpack-plugin");
const webpack = require("webpack");

module.exports = function (env = {}) {
    const plugins = [
        new HtmlWebpackPlugin(
            {
              template: "./src/index.ejs",
              alwaysWriteToDisk: true,
            },
          ),
    ];

    if (env.devserver && !env.optimized) {
        plugins.push(new webpack.HotModuleReplacementPlugin());
    }

    return {
        mode: "development",

        devServer: {
            hot: true,
            proxy: {
                '/graphql': {
                  target: 'http://localhost:42560',
                },
              },
        },

        // Enable sourcemaps for debugging webpack's output.
        devtool: "source-map",

        resolve: {
            // Add '.ts' and '.tsx' as resolvable extensions.
            extensions: [".ts", ".tsx", ".js", ".jsx"],
            modules: [
                'node_modules'
            ],
        },

        module: {
            rules: [
                {
                    test: /\.ts(x?)$/,
                    exclude: /node_modules/,
                    use: [
                        {
                            loader: "ts-loader"
                        }
                    ]
                },
                // All output '.js' files will have any sourcemaps re-processed by 'source-map-loader'.
                {
                    enforce: "pre",
                    test: /\.js$/,
                    loader: "source-map-loader"
                },
                {
                    test: /\.s?[ac]ss$/,
                    use: [
                        "style-loader",
                        "css-loader",
                        { loader: "sass-loader" },
                    ].filter(Boolean),
                  },
            ]
        },

        plugins,
    };
}