package main

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
)

var (
	singleEmoteValues = []struct {
		emote       string
		firstScore  FlavorScore
		secondScore FlavorScore
	}{
		// Base emotes
		{
			":flavortown:",
			FlavorScore{1000, "", "", 1000},
			FlavorScore{1000, "", "", 1000},
		},
		{
			":noflavortown:",
			FlavorScore{-1000, "", "", -1000},
			FlavorScore{-1000, "", "", -1000},
		},
		{
			":negativeflavortown:",
			FlavorScore{-1000, "", "", -1000},
			FlavorScore{-1000, "", "", -1000},
		},
		{
			":fieriparrot:",
			FlavorScore{7500, "", "", 7500},
			FlavorScore{7500, "", "", 7500},
		},
		{
			":spicy:",
			FlavorScore{4000, "solid", "", 4000},
			FlavorScore{4000, "solid", "", 4000},
		},
		{
			":partyparrot:",
			FlavorScore{4000, "", "", 4000},
			FlavorScore{4000, "", "", 4000},
		},
		{
			":notbad:",
			FlavorScore{3888, "", "repeating", 3888},
			FlavorScore{3888, "", "repeating", 3888},
		},
		{
			":ok_hand:",
			FlavorScore{3750, "", "", 3750},
			FlavorScore{3750, "", "", 3750},
		},
		{
			":+1:",
			FlavorScore{3456, "", "", 3456},
			FlavorScore{3456, "", "", 3456},
		},
		{
			":seemsgood:",
			FlavorScore{3247, "roughly", "", 3247},
			FlavorScore{3247, "roughly", "", 3247},
		},
		{
			":harambae:",
			FlavorScore{1122, "", "repeating", 1122},
			FlavorScore{1122, "", "repeating", 1122},
		},
		{
			":ceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{500, "", "", 500},
		},
		{
			":bezos:",
			FlavorScore{500, "", "", 500},
			FlavorScore{500, "", "", 500},
		},
		{
			":flavorbae:",
			FlavorScore{1061, "", "repeating", 1061},
			FlavorScore{1061, "", "repeating", 1061},
		},
		{
			":hypermegaflavordance:",
			FlavorScore{5915, "", "", 5915},
			FlavorScore{5915, "", "", 5915},
		},

		// Base variations
		{
			":negaflavortown:",
			FlavorScore{-1000, "", "", -1000},
			FlavorScore{-1000, "", "", -1000},
		},
		{
			":negaceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{-500, "", "", -500},
		},
		{
			":maybeflavortown:",
			FlavorScore{500, "", "", 500},
			FlavorScore{500, "", "", 500},
		},
		{
			":maybeceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{250, "", "", 250},
		},
		{
			":hyperflavortown:",
			FlavorScore{2000, "", "", 2000},
			FlavorScore{2000, "", "", 2000},
		},
		{
			":hyperceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{1000, "", "", 1000},
		},
		{
			":megaflavortown:",
			FlavorScore{1500, "", "", 1500},
			FlavorScore{1500, "", "", 1500},
		},
		{
			":megaceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{750, "", "", 750},
		},
		{
			":omegaflavortown:",
			FlavorScore{5000, "", "", 5000},
			FlavorScore{5000, "", "", 5000},
		},
		{
			":omegaceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{2500, "", "", 2500},
		},
		{
			":onegaflavortown:",
			FlavorScore{-5000, "", "", -5000},
			FlavorScore{-5000, "", "", -5000},
		},
		{
			":onegaceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{-2500, "", "", -2500},
		},
		{
			":goldenflavortown:",
			FlavorScore{5000, "", "", 5000},
			FlavorScore{5000, "", "", 5000},
		},
		{
			":goldenceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{2500, "", "", 2500},
		},

		// Sillier cases
		{
			":goldengoldengoldengoldenflavortown:",
			FlavorScore{625000, "", "", 625000},
			FlavorScore{625000, "", "", 625000},
		},
		{
			":goldengoldengoldengoldenceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{312500, "", "", 312500},
		},
		{
			":neganegaflavortown:",
			FlavorScore{1000, "", "", 1000},
			FlavorScore{1000, "", "", 1000},
		},
		{
			":neganegaceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{500, "", "", 500},
		},
		{
			":negamaybehypermegaomegaonegagoldenflavortown:",
			FlavorScore{187500, "", "", 187500},
			FlavorScore{187500, "", "", 187500},
		},
		{
			":negamaybehypermegaomegaonegagoldenceelo:",
			FlavorScore{0, "", "", 0},
			FlavorScore{93750, "", "", 93750},
		},
	}
)

func TestSingleEmoteScoring(t *testing.T) {
	for _, values := range singleEmoteValues {
		t.Run(values.emote+" first", func(t *testing.T) {
			f := FlavorScore{}
			f.addEmote(values.emote, true)
			assert.Equal(t, values.firstScore, f, "Expect first score to match for %s", values.emote)
		})
		t.Run(values.emote+" not first", func(t *testing.T) {
			f := FlavorScore{}
			f.addEmote(values.emote, false)
			assert.Equal(t, values.secondScore, f, "Expect second score to match for %s", values.emote)
			fmt.Println(f.toMessage())
		})
	}
}
