package main

import (
	"fmt"

	"github.com/nlopes/slack"
)

func main() {
	token := "todo"
	api := slack.New(token)
	api.SetDebug(true)

	rtm := api.NewRTM()
	go rtm.ManageConnection()

	for msg := range rtm.IncomingEvents {
		fmt.Print("Event Received: ")
		switch ev := msg.Data.(type) {
		case *slack.HelloEvent:
			// Ignore hello

		case *slack.ConnectedEvent:
			fmt.Println("Infos:", ev.Info)
			fmt.Println("Connection counter:", ev.ConnectionCount)
			// Replace #general with your Channel ID
			//rtm.SendMessage(rtm.NewOutgoingMessage("Hello world", "#the-hunt"))

		case *slack.MessageEvent:
			fmt.Printf("Message: %v\n", ev)
			if isFlavorInvocation(ev) {
				score := getFlavorscore(ev)
				rtm.SendMessage(rtm.NewOutgoingMessage(score.toMessage(), "#the-hunt"))
			}

		case *slack.RTMError:
			fmt.Printf("Error: %s\n", ev.Error())

		case *slack.InvalidAuthEvent:
			fmt.Printf("Invalid credentials")
			return

		default:

			// Ignore other events..
			// fmt.Printf("Unexpected: %v\n", msg.Data)
		}
	}
}

func isFlavorInvocation(event *slack.MessageEvent) bool {
	return false
}

func getFlavorscore(event *slack.MessageEvent) FlavorScore {
	score := FlavorScore{}
	// first := true
	// TODO get emotes
	// foreach emote {
	// score.addEmote(emote, first)
	// first = false
	// }
	return score
}
