package internal_test

import (
	"testing"

	"code.justin.tv/spade/code-generator/internal"
	"github.com/stretchr/testify/assert"
)

func Test_ToCamelCase(t *testing.T) {
	assert.Equal(t, "", internal.ToCamelCase(""))
	assert.Equal(t, "0", internal.ToCamelCase("0"))
	assert.Equal(t, "A", internal.ToCamelCase("a"))
	assert.Equal(t, "Hello", internal.ToCamelCase("hello"))
	assert.Equal(t, "HelloThere", internal.ToCamelCase("HelloThere"))
	assert.Equal(t, "HelloThere", internal.ToCamelCase("hello_there"))
}

func Test_ToLowerCamelCase(t *testing.T) {
	assert.Equal(t, "", internal.ToLowerCamelCase(""))
	assert.Equal(t, "0", internal.ToLowerCamelCase("0"))
	assert.Equal(t, "a", internal.ToLowerCamelCase("a"))
	assert.Equal(t, "hello", internal.ToLowerCamelCase("hello"))
	assert.Equal(t, "helloThere", internal.ToLowerCamelCase("HelloThere"))
	assert.Equal(t, "helloThere", internal.ToLowerCamelCase("helloThere"))
	assert.Equal(t, "helloThere", internal.ToLowerCamelCase("hello_there"))
}

func Test_AreAllNumbers(t *testing.T) {
	assert.True(t, internal.AreAllNumbers("-1", "0", "1"))

	assert.False(t, internal.AreAllNumbers(""))
	assert.False(t, internal.AreAllNumbers("abc"))
	assert.False(t, internal.AreAllNumbers("0", "1", "abc", "300", "-2"))
}

func Test_ToStringLiterals(t *testing.T) {
	assert.Equal(t, []string{}, internal.ToStringLiterals([]string{}))
	assert.Equal(t, []string{`"a"`, `"b"`, `"c"`}, internal.ToStringLiterals([]string{"a", "b", "c"}))
}
