# values_to_be_between
This expectation requires the contents of a field to be between two values, inclusive.  If you
require your field to contain a specific value, then you should use
[values_to_be_in_set](values_to_be_in_set.md) instead.  String types are compared lexicographically,
numerical types are compared numerically, and the format of timestamps mean that both comparison
types apply equally.

## Supported Types
* [long](../types/long.md)
* [float](../types/float.md)
* [string](../types/string.md)
* [timestamp](../types/timestamp.md)

## Incompatible Expectations
The following expectations are not allowed to be specified in addition to this expectation.
* [values_to_be_in_set](values_to_be_in_set.md)

## Arguments
* `max` - The maximum value (inclusive).  Must be >= `min`.
* `min` - The minimum value (inclusive).  Must be <= `max`.

## Examples
* TBD
