# Fields
This directory (and possibly subdirectories) contain fields (or columns) used by Spade events.
Each field is defined by a YAML object keyed by the name of the field and stored in a file with the
field name prior to the `.yaml` suffix.  The file naming and one object per file conventions here
are a soft requirement.

Please use the [field template](../templates/field.yaml) when making a new field.

## Arguments
All fields must have a `description` and a `sensitivity`, and it is good practice to make liberal
use of comments in this file.  Please take special care with defining `sensitivity` correctly.  See more
about this in the [contributing guide](../.github/CONTRIBUTING.md#data-sensitivity).

All fields must have either a [`transform`](../transforms/) or a [`type`](../types/) defined. Please
read the corresponding documentation for the arguments for each object.

By default, we expect the name of the field being transmitted by a client matches the name of the
field used downstream of Spade.  This isn't always the case, so you can specify `source` on a `type`
to define a different source field.  This can have pretty bad compounding effects if this field is
shared by many events, so only do this sparingly.

Finally, there are some fields to help with client generation.  These are `internal` to describe a
Spade generated property and `expectations` to define expectations of the data.  While these fields
aren't in use right now, it is best to utilize them correctly to convey your expectations as an
author.

## Example
filename: `ip.yaml`
```yaml
ip:
  # NOTE: If the event sender doesn't send ip data, then the source ip with be extracted from
  # the connection in Spade.  You should rely on this mechanism for client-side events.
  description: The event source's IPv4 address.
  type:
    name: string
    length: 15
  sensitivity: ip
  internal: true
  expectations:
    - name: values_to_not_be_null
    - name: values_to_match_regex_list
      patterns:
        - ^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$
```
