# Spade Schema Registry

Welcome to the Spade Schema Registry repository. The [Spade Schema Registry](https://wiki.xarth.tv/display/DI/Spade+Schema+Registry)
(SSR) is presently an alternative to
Blueprint for defining and managing Spade event schemas. Therefore, schema definitions represent the primary type of
contributions to this repository. Here you can define [events](events/README.md) that leverage a global namespace of
[fields](fields/README.md) and common field [groups](groups/README.md).

**To get started with the Spade Schema Registry**

1. Join [#spade-schema-registry](https://twitch.slack.com/archives/C01GRJVPS02) on Slack and the 
   [spade-schema-developers google group](https://groups.google.com/a/justin.tv/g/spade-schema-developers)
2. Review the [contributing](.github/CONTRIBUTING.md) guidelines.
3. If you want to familiarize yourself with SSR and its workflow before making changes that impact production events,
   use the [events playground](https://git.xarth.tv/spade/events_playground) repo.
4. Read the [SSR docs](https://wiki.xarth.tv/display/DI/Spade+Schema+Registry) and optionally do the tutorials which walks
   through the steps of [creating](https://wiki.xarth.tv/display/DI/SSR+Tutorial+1%3A+Hello+World) a new event in SSR and 
   [importing](https://wiki.xarth.tv/display/DI/SSR+Tutorial+2%3A+Importing+an+Event) an existing event from Blueprint into SSR.
5. Once you are set, go ahead and start contributing to this repository. Feel free to use the provided reference
   [templates](./templates/) while defining new fields and events.


**Making changes to scripts**

If you make changes to scripts in the scripts/ folder, you will need to make sure that those
changes are reflected in the integration test branch of the spade/events repo so they get tested.
This can be done with the following steps:
1. Merge the changes to mainline.
2. Run `./sync_integration.sh`.
3. Run the integration test and make sure it passes.
4. If the integration tests fail, repeat steps 1-3 after rolling back the changes that caused the 
integration tests to fail and get them working, before fixing the underlying cause of the failure.
