# Groups
This directory (and possibly subdirectories) contain collections of fields called groups.  Groups
provide an efficient framework for defining similar events and providing generated clients with the
ability to work with collections of fields at a time.

Each group is defined by a YAML object keyed by the name of the group and stored in a file with the
group name prior to the `.yaml` suffix.  The file naming and one object per file conventions here
are a soft requirement.

## Arguments
All groups must have a `description`, and it is good practice to make liberal use of comments in
this file.

Groups are composed of two lists `fields` and other `groups`.  A group cannot refer to itself, and
these lists must be sorted. There are a couple basic guidelines for reasonable use, so at least one
of the following must be true for a group to be considered valid (yes it is possible to have
exceptions):
* Lists at least one field and one group.
* Lists at least two fields.
* Lists at least two groups.

## Example
filename: `new_events.yaml`
```yaml
new_events:
  description: This is an example of a group that is used when making new events in Blueprint
  fields:
    - user_id
  groups:
    - all_events_common_fields # this is not required to be listed
    - external_ip
```
