AWS Account Template
-----

**DO NOT RUN THIS ON EXISTING ACCOUNTS IN THE SAME REGION UNLESS YOU KNOW WHAT YOU ARE DOING**

**DO NOT CLONE THIS REPO.** That's not how you use it.

Note: _Requires Terraform >=0.11.14 <0.12.0_

This template can be used to stand up a standard Twitch VPC.

**We recommend using the VPC Creator tool explained below to create the terraform configuration.**
This module is tagged and you should always specify the version in your plan.

To setup multiple regions, call this module multiple times setting the region to your desired region.

Be careful with your terraform state files, use an S3 versioned bucket for remote storage.
Do not mix this with other state files and do not run it multiple times against a VPC in a production account.

Included with account_template
------------------------------------------
-   VPC setup utilizing CIDR passed it.
    -   Creates public and private subnets split between Availability Zones.
    -   Sets up a route table for each private subnet.
    -   _OPTIONAL_ Twitch DNS servers attached to VPC Resolver Rules.
    -   _OPTIONAL_ Peering requested to central account(s) for DNS/LDAP latency reduction.
    -   **NOTE: Terraform will request peers and setup the routes, but they will need to be accepted and routes added in the central accounts.  Open a JIRA with IPSYS (Systems Infra) for this work to be completed.**
-   Security group setup whitelisting all Twitch networks, called `twitch_subnets`
-   network-admin-role IAM role used for requesting Direct Connect Virtual Interfaces (backbone connectivity).

Query [#systems-infra](https://twitch.slack.com/messages/C03SYEFUC) for questions you have on this module.

VPC Creator
---

This repo contains a Go application to generate a terraform configuration using account_template.
**Using this is the recommend method for generating the terraform config.**
This tool simply prints out a plan. It's safe and easy to build a starter template.

Use the VPC Creator tool when you're setting up a new AWS account. This tool creates a terraform config you may run
against your new account. The plan creates a VPC that can be used to peer with other VPCs.

#### Prerequisites

If your account needs to peer with other accounts you must receive a CIDR from Networking.
If you are creating a tiny bubble, do not specify a CIDR: a default /22 is provided.

You must have a new AWS account to use the VPC Creator tool and account_template module.
**Once you run the tool, you will need to create the S3 bucket in the new account,
mentioned at the top of the output.** Then you can run `terraform init/plan/apply`.


#### Usage

```shell
# go get latest version
go get -u code.justin.tv/terraform-modules/account_template
# print help
go run code.justin.tv/terraform-modules/account_template -h
# generate template output
go run code.justin.tv/terraform-modules/account_template -ver <branch> <twitch-account-name> <10.200.200.0/22>
```
-   Replace `<twitch-account-name>` with your account's name in Isengard.
-   Replace `<10.200.200.0/22>` with the CIDR networking gave you for this VPC.
-   If the region is different than `us-west-2`, specify it, ie. `-region eu-west-1`
-   The default systems peering configuration is no peering.
    -   If you need to peer with twitch-central-aws account,
        specify `prod` or `nonprod` VPC peer, ie. `-peer nonprod`
-   The `-ver <branch>` flag is for debugging and testing purposes.
-   **Optional arguments come before the name and CIDR.**
-   Save the output to a file in an otherwise empty directory before running terraform `terraform init/plan/apply`..
