# if we are _not_ handed a list of azs, pick some at random. else treat the list as a literal set to interpolate across.

locals {
  # if the length of azset is 0, pick up azletters and run with it.
  az_interpolation = length(var.azset) != 0 ? join(",", data.template_file.inputletters.*.rendered) : join(",", data.template_file.azletters.*.rendered)

  azset = split(",", local.az_interpolation)

  # if the azcount is _not_ zero, try using that, else spray 'n' pray.
  random_azcount = var.azcount != "0" ? var.azcount : length(data.aws_availability_zones.all.names)

  # explicit version for counting
  az_count = length(var.azset) != 0 ? length(var.azset) : local.random_azcount
}

# pick 3 random azs
resource "random_shuffle" "azs" {
  input        = data.aws_availability_zones.all.names
  result_count = local.random_azcount
}

# reduce data from random_shuffle.azs to just the letters.
data "template_file" "azletters" {
  template = "$${letter}"
  count    = local.random_azcount

  vars = {
    letter = upper(
      replace(
        element(random_shuffle.azs.result, count.index),
        "/.*[0-9]/",
        "",
      ),
    )
  }
}

# we actually do the same to our own input to be flexible.
data "template_file" "inputletters" {
  template = "$${letter}"
  count    = length(var.azset)

  vars = {
    letter = upper(replace(element(var.azset, count.index), "/.*[0-9]/", ""))
  }
}

