# this is provided as a static map so we don't rely on our internal account data modules.

locals {
  domain_name_servers = {
    "ap-southeast-1-nonprod" = [
      "10.166.21.45",
      "10.166.20.8",
      "10.166.22.6",
      "10.166.20.191",
    ]
    "ap-southeast-1-prod" = [
      "10.166.21.45",
      "10.166.20.8",
      "10.166.22.6",
      "10.166.20.191",
    ]
    "eu-west-1-nonprod" = [
      "10.176.208.102",
      "10.176.209.84",
      "10.176.208.109",
      "10.176.210.50",
    ]
    "eu-west-1-prod" = [
      "10.176.208.102",
      "10.176.209.84",
      "10.176.208.109",
      "10.176.210.50",
    ]
    "us-east-1-nonprod" = [
      "10.160.8.64",
      "10.160.11.120",
      "10.160.13.247",
      "10.160.15.102",
    ]
    "us-east-1-prod" = [
      "10.160.8.64",
      "10.160.11.120",
      "10.160.13.247",
      "10.160.15.102",
    ]
    "us-east-2-nonprod" = [
      "10.160.8.64",
      "10.160.11.120",
      "10.160.13.247",
      "10.160.15.102",
    ]
    "us-west-2-nonprod" = [
      "10.204.232.126",
      "10.204.233.37",
      "10.204.234.157",
      "10.204.233.199",
    ]
    "us-west-2-prod" = [
      "10.203.126.62",
      "10.203.124.218",
      "10.203.125.211",
      "10.203.126.205",
    ]
  }
  # region with env local comes from peering module.
}

# this controls egress of the vpc resolver endpoints. they can talk to *anything* on port 53 today.
resource "aws_security_group" "dns_to_legacy_resolvestack" {
  name        = "r53_to_legacy_dns"
  description = "outbound resolver SG to twitch legacy DNS servers"
  vpc_id      = aws_vpc.vpc.id
  tags        = module.taglib.tags

  egress {
    from_port   = 53
    to_port     = 53
    protocol    = "udp"
    cidr_blocks = ["0.0.0.0/0"]
  }

  egress {
    from_port   = 53
    to_port     = 53
    protocol    = "tcp"
    cidr_blocks = ["0.0.0.0/0"]
  }

  count = local.region_with_env != "${data.aws_region.current.name}-" ? 1 : 0
}

# Outbound resolver grabs an IP in each subnet and allows queries to leave the VPC and go elsewhere.
# Requires three subnets, which account_template creates and passes in.
resource "aws_route53_resolver_endpoint" "outbound_resolver" {
  name               = "outbound-resolver-${local.region_with_env}"
  direction          = "OUTBOUND"
  security_group_ids = [aws_security_group.dns_to_legacy_resolvestack[0].id]

  # this code allows you to have _4_ subnets. or not. it wraps!
  ip_address {
    subnet_id = element(aws_subnet.private.*.id, 0)
  }

  ip_address {
    subnet_id = element(aws_subnet.private.*.id, 1)
  }

  ip_address {
    subnet_id = element(aws_subnet.private.*.id, 2)
  }

  ip_address {
    subnet_id = element(aws_subnet.private.*.id, 3)
  }

  tags = module.taglib.tags

  count = local.region_with_env != "${data.aws_region.current.name}-" ? 1 : 0
}

# Forward all justin.tv lookups to caches in the peered central VPC.
# Supports up to 8 targets. Empty target IPs are ignored by terraform.
# Four default IPs per VPC are baked into account_template.
resource "aws_route53_resolver_rule" "justintv_forward_rule" {
  domain_name          = "justin.tv"
  rule_type            = "FORWARD"
  name                 = "justintv - Central Caches ${local.region_with_env}"
  resolver_endpoint_id = aws_route53_resolver_endpoint.outbound_resolver[0].id

  target_ip {
    ip = element(local.domain_name_servers[local.region_with_env], 0)
  }

  target_ip {
    ip = element(local.domain_name_servers[local.region_with_env], 1)
  }

  target_ip {
    ip = element(local.domain_name_servers[local.region_with_env], 2)
  }

  target_ip {
    ip = element(local.domain_name_servers[local.region_with_env], 3)
  }

  target_ip {
    ip = element(local.domain_name_servers[local.region_with_env], 4)
  }

  target_ip {
    ip = element(local.domain_name_servers[local.region_with_env], 5)
  }

  target_ip {
    ip = element(local.domain_name_servers[local.region_with_env], 6)
  }

  target_ip {
    ip = element(local.domain_name_servers[local.region_with_env], 7)
  }

  tags = module.taglib.tags

  count = local.region_with_env != "${data.aws_region.current.name}-" ? 1 : 0
}

# Associate the rule with the vpc.
resource "aws_route53_resolver_rule_association" "justintv_forward_rule_association" {
  resolver_rule_id = aws_route53_resolver_rule.justintv_forward_rule[0].id
  vpc_id           = aws_vpc.vpc.id
  count            = local.region_with_env != "${data.aws_region.current.name}-" ? 1 : 0
}

