module "taglib" {
  source      = "git::git+ssh://git@git.xarth.tv/terraform-modules/taglib?ref=v0.4"
  name        = var.name
  owner       = "systems"
  service     = "vpc"
  srctag      = "terraform-modules:account_template"
  tags        = var.tags
  environment = lookup(var.tags, "Environment", "devel")
}

# Installs a Network Admin Role
module "network_admin_role" {
  source = "git::git+ssh://git@git.xarth.tv/terraform-modules/network-admin-role?ref=v2.1.0"
  create = var.force_bootstrap
}
