package main

import (
	"flag"
	"fmt"
	"log"
	"os"
	"strings"

	"code.justin.tv/terraform-modules/account_template/vpccreator"
)

func main() {
	v := ParseFlags()
	if err := v.SetOptions().Validate(); err != nil {
		flag.Usage()
		log.Fatalf("[ERROR] %v", err)
	}
	if err := v.Render(); err != nil {
		log.Fatalf("[ERROR] %v", err)
	}
}

// ParseFlags turns the cli args into a vpccreator struct.
func ParseFlags() *vpccreator.VPC {
	flag.Usage = func() {
		fmt.Fprintf(os.Stderr, "This application prints out a terraform plan for account_template.\n"+
			"It does not take any actions. It is safe to test.\n\n"+
			"Usage: %s [-peer <prod|nonprod>] [-region <region>] [-ver <version>] <account-name> <CIDR>\n"+
			"- Account name example: twitch-myservice-prod (required)\n"+
			"- CIDR example: 10.200.200.0/22 (required)\n"+
			"- Optional arguments come before the name and CIDR.\n", os.Args[0])
		flag.PrintDefaults()
	}

	region := flag.String("region", vpccreator.DefaultRegion,
		"supported: "+strings.Join(vpccreator.SupportedRegions, ", "))
	peer := flag.String("peer", "",
		"peered central VPC; default is no peering, allowed: "+strings.Join(vpccreator.SupportedSysEnvs, ", "))
	ver := flag.String("ver", vpccreator.DefaultVersion,
		"Find more versions: https://"+vpccreator.AccountTemplate+"/releases")

	flag.Parse()
	return &vpccreator.VPC{
		AccountName: flag.Arg(0),
		CIDR:        flag.Arg(1),
		Region:      *region,
		SysEnv:      *peer,
		Version:     *ver,
	}
}
