# These are default peering for DNS
# They must still be accepted on the remote side to function correctly.

locals {
  # this points back to the twitch systems vpc nearest you, with any hope.
  # return map {account,vpcid,cidr}
  closest_vpc = {
    "ap-southeast-1-prod" = {
      "account" = "007917851548"
      "vpcid"   = "vpc-2c0fe84b"
      "cidr"    = "10.166.20.0/22"
    }
    "ap-southeast-1-nonprod" = {
      "account" = "007917851548"
      "vpcid"   = "vpc-2c0fe84b"
      "cidr"    = "10.166.20.0/22"
    }
    "eu-west-1-prod" = {
      "account" = "007917851548"
      "vpcid"   = "vpc-de0877b9"
      "cidr"    = "10.176.208.0/22"
    }
    "eu-west-1-nonprod" = {
      "account" = "007917851548"
      "vpcid"   = "vpc-de0877b9"
      "cidr"    = "10.176.208.0/22"
    }
    "us-east-1-prod" = {
      "account" = "007917851548"
      "vpcid"   = "vpc-937a6cf4"
      "cidr"    = "10.160.0.0/20"
    }
    "us-east-1-nonprod" = {
      "account" = "007917851548"
      "vpcid"   = "vpc-937a6cf4"
      "cidr"    = "10.160.0.0/20"
    }
    "us-east-2-nonprod" = {
      "account" = "007917851548"
      "vpcid"   = "vpc-937a6cf4"
      "cidr"    = "10.160.0.0/20"
    }
    "us-west-2-nonprod" = {
      "account" = "007917851548"
      "vpcid"   = "vpc-0dbbf83a0668ac7ae"
      "cidr"    = "10.204.232.0/22"
    }
    "us-west-2-prod" = {
      "account" = "007917851548"
      "vpcid"   = "vpc-84063ffd"
      "cidr"    = "10.203.124.0/22"
    }
  }

  region_with_env = "${data.aws_region.current.name}-${var.systems_peer}"
}

# Prod Central DNS/LDAP/Puppet/Syslog
resource "aws_vpc_peering_connection" "twitch_systems_peer" {
  peer_owner_id = lookup(local.closest_vpc[local.region_with_env], "account", "")
  peer_vpc_id   = lookup(local.closest_vpc[local.region_with_env], "vpcid", "")
  vpc_id        = aws_vpc.vpc.id

  tags = module.taglib.tags

  count = local.region_with_env != "${data.aws_region.current.name}-" ? 1 : 0
}

resource "aws_route" "twitch_peering_route" {
  route_table_id = element(
    concat(
      [aws_default_route_table.vpc.id],
      aws_route_table.private_rt.*.id,
    ),
    count.index,
  )
  vpc_peering_connection_id = aws_vpc_peering_connection.twitch_systems_peer[0].id
  destination_cidr_block    = local.closest_vpc[local.region_with_env]["cidr"]

  # this resolves to all the private subnets + 1 (the VPC RT)
  count = local.region_with_env != "${data.aws_region.current.name}-" ? local.az_count + 1 : 0
}

