# Autogenerated by https://code.justin.tv/terraform-modules/account_template/vpccreator
#
# Using terraform 0.11.14, run this like so:
# terraform init ; terraform plan
#
# Credentials must be available for account 'twitch-central-dev'
#
terraform {
  backend "s3" {
    # This bucket must be created manually before this plan will run!
    bucket  = "twitch-central-dev"
    key     = "tfstate/account_template/us-east-1/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-central-dev"
  }
}

provider "aws" {
  profile = "twitch-central-dev"
  alias   = "twitch-central-dev-us-east-1"
  region  = "us-east-1"
}

module "us-east-1" {
  enable_vgw   = "false" # set true if using direct-connects
  name         = "twitch-central-dev"
  owner        = "twitch-central-dev@amazon.com"
  source       = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/account_template.git?ref=v3.1.3"
  vpc_cidr     = "10.205.56.0/22"
  systems_peer = "nonprod"

  # Set additional resource tags by uncommenting this line, and adding tags.
  tags = "${map("Environment", "terratest")}"

  providers {
    aws = "aws.twitch-central-dev-us-east-1"
  }
}

output "us_east_1_private_subnets" {
  value = "${module.us-east-1.private_subnets}"
}

output "us_east_1_public_subnets" {
  value = "${module.us-east-1.public_subnets}"
}

output "us_east_1_twitch_subnets_sg_id" {
  value = "${module.us-east-1.twitch_subnets_sg_id}"
}

output "us_east_1_vpc_id" {
  value = "${module.us-east-1.vpc_id}"
}

output "us_east_1_azset" {
  value = "${module.us-east-1.azset}"
}
