variable "vpc_cidr" {
  type        = string
  description = "Networking provided CIDR for VPC. e.g. 999.999.99.999/99"
}

variable "name" {
  type        = string
  description = "default name for created objects"
}

variable "systems_peer" {
  type        = string
  default     = ""
  description = "Systems environment to peer with - either <blank>, prod or nonprod."
}

variable "tags" {
  type        = map(string)
  default     = {}
  description = "additional resource tags"
}

variable "owner" {
}

variable "default_internet_public_map" {
  type        = string
  default     = "true"
  description = "enable default public ipv4 address allocation in public subnets"
}

variable "enable_vgw" {
  type        = string
  default     = "false"
  description = "enable AWS VPN gateway service for VPC"
}

variable "dns_domain_suffix" {
  type        = string
  default     = ""
  description = "override default compute.internal domain suffix"
}

variable "dns_domain_infix" {
  type        = string
  default     = ""
  description = "override default region name in <region>.compute.internal dns"
}

variable "dns_domain" {
  type        = string
  default     = ""
  description = "override the entire internal DNS name in DHCP options"
}

variable "route53_resolverset" {
  type        = string
  default     = "false"
  description = "configure a Route53 resolverset for some legacy twitch DNS usage"
}

variable "force_bootstrap" {
  type        = string
  default     = "default"
  description = "force configure IAM bootstrapping from network_admin_role"
}

variable "azset" {
  type        = list(string)
  default     = []
  description = "list of azs to deploy subnets in - [a,b,d] - default is all discovered AZs"
}

variable "azcount" {
  type        = string
  default     = "0"
  description = "count of AZs to create subnets in IF NOT PASSING AZSET - default is all discovered azs"
}
