# alb
Simple ALB (application) creation module.

Listens to HTTPS (443) and rewrites requests from HTTP (80) to HTTPS (443).

## Requirements

The latest version of this module will only work with terraform `0.12` and above. If you need to use this module with older versions of terraform, use `v1.0.0`.

## Inputs

### Required

* `service`: Name of service. E.g. `ganglia`, `cool-http`, etc).
* `owner`: Service owner name (e.g. <groupname>@twitch.tv).
* `vpc_id`: VPC of where this ALB should exist in.
* `subnets` (list): List of subnets (and thus availability zones) that this ALB should exist in.
* `security_groups` (list): List of security groups to apply to ALB.
* `instance_ids` (list): List of instance IDs to be attached to ALB target group.
* `instance_count`: The number/count of instance_ids i.e. (length(instance_ids)).
* `ssl_certificate_arn`: SSL certificate to use for HTTPS.
* `r53_zone_id`: Zone to create vanity alias A record to ALB.

### Optional

* `instance_protocol`: Protocol to use for routing traffic to targets. Defaults to `HTTP`.
* `instance_port`: The port on which targets receive traffic. Defaults to `80`.

### Optional ALB healthcheck inputs

* `healthcheck_interval`: Defaults to `10` seconds.
* `healthcheck_path`: Defaults to `/`.
* `healthcheck_healthy_threshold`: Defaults to `3`.
* `healthcheck_unhealthy_threshold`: Defaults to `3`.
* `healthcheck_matcher`: Defaults to `200`.

Refer to terraform [Health Check Blocks](https://www.terraform.io/docs/providers/aws/r/lb_target_group.html#health_check) for more information.

### Optional AWS account and environment setup

* `environment`: `prod`, `stage`, or `dev`. Defaults to `prod`.
* `account`: AWS account to create ALB in. Defaults to current AWS session.
* `region`: Defaults to `us-west-2`.
* `r53_profile`: AWS account to create ALB A records. Defaults to `account` AWS.

## What's generated

* ALB named `$service-$environment-lb`
* DNS record for `$service.<zonename>` pointing to the ALB.
