# Required

variable "service" {
}

variable "owner" {
}

variable "vpc_id" {
}

variable "subnets" {
  type = list(string)
}

variable "security_groups" {
  type = list(string)
}

variable "instance_ids" {
  type = list(string)
}

variable "instance_count" {
}

variable "ssl_certificate_arn" {
}

variable "r53_zone_id" {
}

# Optional

variable "instance_protocol" {
  default = "HTTP"
}

variable "instance_port" {
  default = "80"
}

# Optional Healthchecks

variable "healthcheck_interval" {
  default = 10
}

variable "healthcheck_path" {
  default = "/"
}

variable "healthcheck_healthy_threshold" {
  default = "3"
}

variable "healthcheck_unhealthy_threshold" {
  default = "3"
}

variable "healthcheck_matcher" {
  default = "200"
}

# Optional AWS account and environment setup

variable "environment" {
  default = "production"
}

variable "account" {
  default = ""
}

variable "region" {
  default = "us-west-2"
}

variable "r53_profile" {
  default = ""
}
