resource "aws_autoscaling_lifecycle_hook" "launching" {
  name                    = "dns-lifecycle-launching"
  autoscaling_group_name  = aws_autoscaling_group.asg.name
  default_result          = "ABANDON"
  heartbeat_timeout       = 60
  lifecycle_transition    = "autoscaling:EC2_INSTANCE_LAUNCHING"
  notification_target_arn = module.autoscale_dns.autoscale_handling_sns_topic_arn
  role_arn                = module.autoscale_dns.agent_lifecycle_iam_role_arn
}

resource "aws_autoscaling_lifecycle_hook" "terminating" {
  name                    = "dns-lifecycle-terminating"
  autoscaling_group_name  = aws_autoscaling_group.asg.name
  default_result          = "CONTINUE"
  heartbeat_timeout       = 60
  lifecycle_transition    = "autoscaling:EC2_INSTANCE_TERMINATING"
  notification_target_arn = module.autoscale_dns.autoscale_handling_sns_topic_arn
  role_arn                = module.autoscale_dns.agent_lifecycle_iam_role_arn
}

module "autoscale_dns" {
  source = "git@git-aws.internal.justin.tv:terraform-modules/terraform-aws-asg-dns-handler?ref=tf12_1.0.3.3"

  autoscale_handler_unique_identifier = "${var.service}-asg-dns"
  vpc_name                            = var.vpc_id
  autoscale_route53zone_id            = var.route53_zone_id
}
