# Legacy mappings of environment long names
locals {
  environment_map = {
    prod  = "production"
    stage = "staging"
    dev   = "development"
  }

  environment = local.environment_map[var.env]

  common_tags = {
    Owner       = var.owner
    Service     = var.service
    Environment = var.env
    Source      = "terraform-modules/tf-mod-autoscaling"
  }

  puppet_team = var.puppet_team != "" ? var.puppet_team : var.owner
}
