variable "service" {
  description = "The name of the service"
}

variable "owner" {
  description = "The team email address of the owner of the service"
}

variable "vpc_id" {
  description = "The VPC id this ASG will be running in"
}

variable "region" {
  description = "The AWS region this ASG will be running in"
}

variable "route53_zone_id" {
  description = "The route53 zone id that will create DNS names"
}

variable "subnet_ids" {
  type        = list(string)
  description = "A list of subnet IDs to launch resources in"
}

variable "security_group_ids" {
  type        = list(string)
  description = "A list of associated security group ids"
}

# Optional variables

variable "env" {
  description = "The environment of this service. Either dev, stage, prod"
  default     = "dev"
}

variable "user_data" {
  description = "The user data to provide when launching the instance. Do not pass gzip-compressed data via this argument"
  default     = ""
}

variable "user_data_post_puppet" {
  description = "The user data to be run post puppet agent run"
  default     = ""
}

variable "min_size" {
  type        = number
  description = "The minimum size of the autoscale group"
  default     = 1
}

variable "max_size" {
  type        = number
  description = "The maximum size of the autoscale group"
  default     = 1
}


variable "instance_type" {
  description = "The size of EC2 instance to launch"
  default     = "t2.micro"
}

variable "tags" {
  type        = map(string)
  description = "Common tags to be passed to resources"
  default     = {}
}

variable "health_check_type" {
  description = "'EC2' or 'ELB'. Controls how health checking is done"
  default     = "EC2"
}

variable "target_group_arns" {
  type        = list(string)
  description = "A list of aws_alb_target_group ARNs, for use with Application or Network Load Balancing"
  default     = []
}

variable "asg_depends_on" {
  type        = list(string)
  description = "A list of terraform explicit dependencies to be passed to the ASG"
  default     = []
}

variable "ebs_block_device" {
  type        = list(map(string))
  description = "Additional EBS block devices to attach to the instance"
  default     = []
}

variable "puppet_server" {
  description = "The puppet master to run puppet client against"
  default     = "video-puppet.prod.puppet.live-video.a2z.com"
}

variable "puppet_ca_server" {
  description = "The Puppet CA server to run puppet client against"
  default     = "video-puppet-ca.prod.puppet.live-video.a2z.com"
}

variable "puppet_team" {
  description = "aka twitch_team. Defaults to owner if not specified"
  default     = ""
}
