#cloud-config
preserve_hostname: true
manage_etc_hosts: false
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo "${role}-$INSTANCE_ID" | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${env}.${dns_region}.justin.tv $(cat /etc/hostname) >> /etc/hosts"
runcmd:
 - echo "twitch_environment=${environment}" > /etc/facter/facts.d/twitch_environment.txt
 - echo "twitch_role=${role}" > /etc/facter/facts.d/twitch_role.txt
 - echo "twitch_team=${owner}" > /etc/facter/facts.d/twitch_team.txt
 - echo "cluster=${role}" > /etc/facter/facts.d/cluster.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "disable_consul=true" > /etc/facter/facts.d/disable_consul.txt
 - puppet agent --test --server=${puppet} > /var/log/first-puppet.log 2>&1
write_files:
  - content: |
      # Enable sudoers for SSM
      ssm-user   ALL=(ALL)  NOPASSWD:ALL
    path: "/etc/sudoers.d/99-ssm-user"
    permissions: '0440'
    owner: root:root
