# Input arguments, required

variable "account" {}

variable "subnet_ids" {
  type = "list"
}

variable "vpc_security_group_ids" {
  type = "list"
}

variable "service" {}
variable "role" {}
variable "environment" {}
variable "ami" {}
variable "owner" {}

# By default make a new instance_profile
# Override with profile name to use an existing one
variable "instance_profile" {
  default = "create"
}

# Static IP mappings, should be subnet-id = "IPV4"
variable "private_ip" {
  type = "map"
}

# Input arguments, optional
variable "region" {
  default = "us-west-2"
}

variable "instance_type" {
  default = "m4.large"
}

variable "r53_zone_id" {
  type = "map"

  default = {
    us-west-2      = "ZRG00SM48517Z"
    us-east-1      = "Z177PQ2GE292U3"
    eu-west-1      = "Z1RE36DARE2RLE"
    ap-southeast-1 = "Z3D71RF114NJ6V"
  }
}

variable "puppet" {
  default = "puppet"
} # as opposed to puppet-ci

variable "root_block_device_size" {
  default = 32
}

variable "additional_facts" {
  default = []
  type    = "list"
}

variable "additional_iam_roles" {
  default = []
  type    = "list"
}

variable "count" {
  default = 1
}

# Internal variables, mostly maps to use to generate secondary variables
# based on the passed in arguments
variable "puppet_server" {
  type = "map"

  default = {
    puppet    = "puppet.internal.justin.tv"
    puppet-ci = "puppet.prod.us-west2.justin.tv"
  }
}

# For use with creating FQDNs
variable "environment_shortname" {
  type = "map"

  default = {
    production  = "prod"
    staging     = "staging"
    development = "dev"
  }
}

variable "dns_region" {
  type = "map"

  default = {
    us-west-2      = "us-west2"
    us-east-1      = "us-east-1"
    eu-west-1      = "eu-west-1"
    ap-southeast-1 = "ap-southeast-1"
  }
}

# For use with tagging semantics as laid out
# by the capacity planing team. Used as the Environment
# tag given to the EC2 instance
variable "environment_tagname" {
  type = "map"

  default = {
    production  = "prod"
    staging     = "stage"
    development = "dev"
  }
}

# Used for Chasqui tags
variable "chasqui_service" {
  default = ""
}

variable "chasqui_stage" {
  default = ""
}

# Outputs
output "instance_ids" {
  value = ["${aws_instance.instance.*.id}"]
}

output "iam_role_id" {
  value = "${aws_iam_role.iam_role.*.id}"
}

output "fqdns" {
  value = ["${aws_route53_record.instance_dns.*.fqdn}"]
}

output "iam_role_name" {
  value = "${aws_iam_role.iam_role.*.name}"
}
