Twitch AWS Instance
===

Creates one (or many) AWS instances with the specified role, along with several
convenience resources to go along with it.


Input Variables
---
```environment - Should be production or development, determines dns name and tagging
account - name of account that matches a credential profile
region - region to create instance in
vpc_security_group_ids - List of security groups to attach
subnet_ids - List of subnet ids to use
service - name of service, for tagging and naming in dns
role - Role to be used for instance profile and puppet
ami - ami-id to use
instance_type - type of instance to use
owner - owner for tagging purposes
count - how many instances to spin up
```
Pass in a map of subnets to IP you should use for static assigments:

```
variable "private_ip" {
  type = "map"
  default = {
    subnet-ID = "10.x.x.x"
    subnet-ID = "10.x.x.x"
    subnet-ID = "10.x.x.x"
    subnet-ID = "10.x.x.x"
  }
}

```
Optionally pass in an existing instance_profile if you do not want to automatically create a new profile.

```instance_profile        = "example-existing-profile"``` 

** the profile must exist, be sure you use dependancy mapping via outputs

Optionally pass in a map of files to create in the instance - this maps to the `write_files` stanza in cloud-init.

```
variable "files" {
  type = "map"
  default = {
    "/path/to/file" = {
      owner       = "uid:gid"
      permissions = "0775"
      content     = "stick to text you are inside a yaml document eventually."
    }
  }
}
```

Created Resources
---

- AWS Instances
- A single instance profile called `<role>-<environment>-profile` that is shared among the instances
- A single IAM Role which is attached to the instance profile
- Internal DNS `A` records pointing to the instances, of the form `<role>-<id>.<env>.us-west2.justin.tv`
