data "aws_route53_zone" "r53zone" {
  zone_id      = "${var.r53_zone_id}"
  private_zone = false
}

# DNS records for each host
resource "aws_route53_record" "instance_dns" {
  count   = local.instance_count
  zone_id = var.r53_zone_id
  name    = "${var.service}-${replace(element(aws_instance.instance.*.id, count.index), "i-", "")}.${data.aws_region.current.name}"
  type    = "A"
  ttl     = "14400"
  records = [element(aws_instance.instance.*.private_ip, count.index)]
}
