variable "files" {
  default     = {}
  description = "nested map of (path => content, permissions, owner) file blocks"
  type        = map
}

locals {
  # _this_ files gets handed to the template. in `main.tf`. join all instances of `ec2data_files` below and add the `write_files` key in cloud-init YAML.
  files = join("",data.template_file.ec2data_files.*.rendered) == "" ? "" : "write_files:\n${join("",data.template_file.ec2data_files.*.rendered)}"

  # this local gets handed to the below `ec2data_files` template as the final list of files to create templates for.
  # this is so we _always_ create the ssm user sudo block. and it's a handy example of how to use the thing.
  filemap = merge(var.files,map("/etc/sudoers.d/99-ssm-user",
               map("content","# Enable sudoers for SSM\nssm-user ALL=(ALL) NOPASSWD: ALL",
                   "permissions","0440",
                   "owner","root:root")))
}

# for every file in our filemap local, render the file to...cloud-init YAML subkeys. path and content are required. path is the key in the filemap.
# content is a subkey in the filemap local.
# permissions and owner are not required subkeys. and that's achieved by trying lookups and rendering to empty strings if they do not resolve.
data "template_file" "ec2data_files" {
  count    = length(keys(local.filemap))
  template = "  - path: \"$${path}\"\n    content: |\n      $${content}\n$${permissions}$${owner}"

  vars = {
    path        = element(keys(local.filemap),count.index)
    content     = indent(6,lookup(local.filemap[element(keys(local.filemap),count.index)],"content"))
    permissions = lookup(local.filemap[element(keys(local.filemap),count.index)],"permissions","") == "" ? "" : "    permissions: ${lookup(local.filemap[element(keys(local.filemap),count.index)],"permissions","")}\n"
    owner       = lookup(local.filemap[element(keys(local.filemap),count.index)],"owner","") == "" ? "" : "    owner: ${lookup(local.filemap[element(keys(local.filemap),count.index)],"owner","")}\n"
  }
}
